'use client';

import Header from '../../../components/Header';
import MobileHeader from '../../../components/MobileHeader';
import Footer from '../../../components/Footer';
import { useTranslations, useLocale } from 'next-intl';
import { useState, useEffect, useRef } from 'react';
import Image from 'next/image';
import Link from 'next/link';
import AnimatedText from '../../../components/AnimatedText';
import AnimatedElement from '../../../components/AnimatedElement';
  import './zoom-in.css';

export default function VillasLayoutPage() {
  const t = useTranslations('VillasLayoutPage');
  const tCommon = useTranslations('Common');
  const [isDesktop, setIsDesktop] = useState(false);
  const locale = useLocale();

  useEffect(() => {
    const checkScreenSize = () => {
      setIsDesktop(window.innerWidth >= 1024);
    };

    checkScreenSize();
    window.addEventListener('resize', checkScreenSize);

    return () => window.removeEventListener('resize', checkScreenSize);
  }, []);

  const getLocalizedPath = (path: string) => {
    if (path === '/') {
        return `/${locale}`;
    }
    return `/${locale}${path}`;
  }

  const [parallaxScale, setParallaxScale] = useState(1);
  const parallaxRef = useRef<HTMLDivElement>(null);
  useEffect(() => {
    const handleScroll = () => {
      if (!parallaxRef.current) return;
      const rect = parallaxRef.current.getBoundingClientRect();
      const windowHeight = window.innerHeight;
      // Чем выше блок на экране, тем больше scale
      const visible = Math.max(0, Math.min(1, 1 - rect.top / windowHeight));
      setParallaxScale(1 + visible * 0.15); // scale от 1 до 1.15
    };
    window.addEventListener('scroll', handleScroll);
    handleScroll();
    return () => window.removeEventListener('scroll', handleScroll);
  }, []);

  if (isDesktop) {
    // Desktop Version
    return (
      <div className="flex w-full flex-col items-start bg-[#F5F1F0] font-roboto">
        {/* Header */}
        <div className="flex h-[65px] px-8 justify-between items-center w-full bg-white">
          <div className="flex max-w-[1376px] justify-between items-center flex-1 mx-auto">
            <Header />
          </div>
        </div>
        
        {/* Panorama Section */}
        <section className="flex pb-[50px] flex-col justify-end items-center gap-6 w-full">
          <div 
            className="flex h-[597px] flex-col justify-end items-center gap-6 w-full relative"
            style={{
              background: "linear-gradient(180deg, rgba(0, 0, 0, 0.50) 0%, rgba(0, 0, 0, 0.19) 100%), url('/images/villas/07c00710b3cdaf28277b51aaf038ee63b59ba416.jpg') lightgray 50% / cover no-repeat"
            }}
          >
            <div className="flex max-w-[1376px] flex-col items-start gap-6 flex-1 w-full mx-auto p-8">
              <div className="flex flex-col justify-between items-start flex-1 w-full">
                <AnimatedText
                  as="h1"
                  animation="slideInUp"
                  delay={200}
                  className="w-full text-white text-center text-[40px] font-light leading-[115%] tracking-[-1.2px] font-roboto"
                >
                  {t('title')}
                </AnimatedText>

              </div>
            </div>
          </div>
        </section>

        {/* Lake Token Section */}
        <section className="flex w-full h-[480px] px-8 py-[150px] justify-center items-center gap-10 bg-white">
          <div className="flex max-w-[1376px] flex-col items-start gap-10 flex-1 mx-auto">
            <div className="flex flex-col items-start gap-3 w-full">
              <AnimatedText
                as="h2"
                animation="slideInUp"
                delay={200}
                className="w-full text-[#1C1C1C] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
              >
                {t('token_title')}
              </AnimatedText>
            </div>
            <AnimatedElement
              animation="slideInUp"
              delay={400}
            >
              <Link href={getLocalizedPath('/lake-token')} className="flex py-3 px-6 justify-center items-center gap-2 rounded-[2px] bg-[#A79D94] hover:bg-[#9a8f86] transition-colors">
                <span className="text-[#F5F1F0] font-roboto text-lg font-normal leading-[150%]">
                  {tCommon('lake_token')}
                </span>
              </Link>
            </AnimatedElement>
          </div>
        </section>

        {/* Cards Section */}
        <section className="flex pb-[60px] flex-col justify-center items-center gap-10 w-full">
          <div className="flex max-w-[1440px] px-8 items-start gap-8 w-full mx-auto">
            
            {/* First Card - Interior Comfort */}
            <div className="flex w-[672px] flex-col items-start">
              <AnimatedElement
                animation="slideInLeft"
                delay={200}
                className="flex h-[672px] pr-6 items-start gap-2 w-full bg-cover bg-center"
              >
                <div
                  className="w-full h-full bg-cover bg-center"
                  style={{
                    backgroundImage: "url('/images/villas/d953f051613bd23ab3c127138dfd01862652719d.jpg')",
                    backgroundColor: 'lightgray'
                  }}
                />
              </AnimatedElement>
              <div className="flex pt-6 flex-col items-start gap-4 w-full">
                <AnimatedText
                  as="h3"
                  animation="slideInLeft"
                  delay={400}
                  className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
                >
                  {t('card1_title')}
                </AnimatedText>
                <AnimatedText
                  as="p"
                  animation="slideInLeft"
                  delay={500}
                  className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
                >
                  {t('card1_desc')}
                </AnimatedText>
              </div>
            </div>

            {/* Second Card - Innovative Technologies */}
            <div className="flex w-[672px] flex-col items-start">
              <AnimatedElement
                animation="slideInRight"
                delay={200}
                className="flex h-[672px] pr-6 items-start gap-2 w-full bg-cover bg-center"
              >
                <div className="w-full h-full overflow-hidden">
                <div
                    className="zoom-image"
                  style={{
                      width: '100%',
                      height: '100%',
                    backgroundImage: "url('/images/villas/5939fcb782e9680236db5dbc0bd4808fd4223306.jpg')",
                    backgroundColor: 'lightgray',
                      backgroundSize: 'cover',
                      backgroundPosition: 'center',
                  }}
                />
                </div>
              </AnimatedElement>
              <div className="flex pt-6 flex-col items-start gap-4 w-full">
                <AnimatedText
                  as="h3"
                  animation="slideInRight"
                  delay={400}
                  className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
                >
                  {t('card2_title')}
                </AnimatedText>
                <AnimatedText
                  as="p"
                  animation="slideInRight"
                  delay={500}
                  className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
                >
                  {t('card2_desc')}
                </AnimatedText>
              </div>
            </div>

          </div>
        </section>

        <Footer />
      </div>
    );
  }

  // Mobile Version (375px)
  return (
    <div className="flex w-full flex-col items-start bg-[#F5F1F0] font-roboto">
      {/* Mobile Header */}
      <div className="flex py-[5px] justify-between items-center w-full bg-white">
        <MobileHeader />
      </div>

      {/* Mobile Panorama Section */}
      <section className="flex pb-[50px] flex-col justify-end items-center gap-6 w-full">
        <div 
          className="flex h-[597px] flex-col justify-end items-center gap-6 w-full relative"
          style={{
            background: "linear-gradient(180deg, rgba(0, 0, 0, 0.50) 0%, rgba(0, 0, 0, 0.19) 100%), url('/images/villas/07c00710b3cdaf28277b51aaf038ee63b59ba416.jpg') lightgray 50% / cover no-repeat"
          }}
        >
          <div className="flex flex-col items-start gap-6 flex-1 w-full p-8">
            <div className="flex flex-col justify-between items-start flex-1 w-full">
              <AnimatedText
                as="h1"
                animation="slideInUp"
                delay={200}
                className="w-full text-white text-center text-[40px] font-light leading-[115%] tracking-[-1.2px] font-roboto"
              >
                {t('title')}
              </AnimatedText>

            </div>
          </div>
        </div>
        
        {/* Mobile Description Section */}
        <div className="flex px-3 flex-col justify-end items-center gap-2 w-full">
          <div className="flex pl-6 flex-col items-start gap-4 border-l border-[rgba(28,28,28,0.20)] w-full">
            <AnimatedText
              as="p"
              animation="slideInUp"
              delay={600}
              className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
            >
              {t('description')}
            </AnimatedText>
          </div>
        </div>
      </section>

      {/* Mobile Lake Token Section */}
      <section className="flex px-3 py-[150px] justify-center items-center gap-10 w-full bg-white">
        <div className="flex flex-col items-start gap-10 flex-1">
          <div className="flex flex-col items-start gap-3 w-full">
            <AnimatedText
              as="h2"
              animation="slideInUp"
              delay={200}
              className="w-full text-[#1C1C1C] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('token_title')}
            </AnimatedText>
          </div>
          <AnimatedElement
            animation="slideInUp"
            delay={400}
          >
            <Link href={getLocalizedPath('/lake-token')} className="flex py-3 px-6 justify-center items-center gap-2 w-full rounded-[2px] bg-[#A79D94] hover:bg-[#9a8f86] transition-colors">
              <span className="text-[#F5F1F0] font-roboto text-lg font-normal leading-[150%]">
                {tCommon('lake_token')}
              </span>
            </Link>
          </AnimatedElement>
        </div>
      </section>

      {/* Mobile Cards Section */}
      <section className="flex pb-[60px] flex-col justify-center items-center gap-10 w-full">
        <div className="flex px-3 flex-col items-start gap-8 w-full">
          
          {/* First Card - Interior Comfort */}
          <div className="flex flex-col items-start w-full">
            <AnimatedElement
              animation="slideInUp"
              delay={300}
              className="flex h-[351px] items-start gap-1 w-full bg-cover bg-center"
            >
              <div
                className="w-full h-full bg-cover bg-center"
                style={{
                  backgroundImage: "url('/images/villas/d953f051613bd23ab3c127138dfd01862652719d.jpg')",
                  backgroundColor: 'lightgray'
                }}
              />
            </AnimatedElement>
            <div className="flex pt-6 flex-col items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={400}
                className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
              >
                {t('card1_title')}
              </AnimatedText>
              <AnimatedText
                as="p"
                animation="slideInUp"
                delay={500}
                className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
              >
                {t('card1_desc')}
              </AnimatedText>
            </div>
          </div>

          {/* Second Card - Innovative Technologies */}
          <div className="flex flex-col items-start w-full">
            <AnimatedElement
              animation="slideInUp"
              delay={300}
              className="flex h-[351px] items-start gap-1 w-full bg-cover bg-center"
            >
              <div className="w-full h-full overflow-hidden">
              <div
                  className="zoom-image"
                style={{
                    width: '100%',
                    height: '100%',
                  backgroundImage: "url('/images/villas/5939fcb782e9680236db5dbc0bd4808fd4223306.jpg')",
                    backgroundColor: 'lightgray',
                    backgroundSize: 'cover',
                    backgroundPosition: 'center',
              }}
              />
              </div>
            </AnimatedElement>
            <div className="flex pt-6 flex-col items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={400}
                className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
              >
                {t('card2_title')}
              </AnimatedText>
              <AnimatedText
                as="p"
                animation="slideInUp"
                delay={500}
                className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
              >
                {t('card2_desc')}
              </AnimatedText>
            </div>
          </div>

        </div>
      </section>

      <Footer />
    </div>
  );
} 